/* fractions.cp */

#include "typedef.h"
#include "fractions.h"
#include "reduce.h"
#include <math.h>
static double logMax=21.4875625973583; // log(pow(2,31))

static long absL(long x)
{
	if(x<0)
		x = -x;
		
	return x;
	
}/* absL */


static bool isGoodAdd(long x, long y)
{
	if((x>=0 && y<=0) || (x<=0 && y>=0))
		return true;
	
	if((absL(x)+absL(y))<0)
		return false;
	
	return true;
	
}/* isGoodAdd */


static bool isGoodSub(long x, long y)
{
	if((x>=0 && y>=0) || (x<=0 && y<=0))
		return true;
	
	if((absL(x)+absL(y))<0)
		return false;
	
	return true;
	
}/* isGoodSub */


static bool isGoodMul(long x, long y)
{
	if(x==0 || y==0)
		return true;

	if((log(absL(x))+log(absL(y)))<logMax)
		return true;
	else
		return false;
	
}/* isGoodMul */


static bool isGoodPow(long x, long y)
{
	if(x==0)
		return true;
	
	if(absL(y)*log(absL(x))<logMax)
		return true;
	else
		return false;
	
}/* isGoodPow */


// checks if two fractions are equal, we rely on each being in lowest terms
bool isEqualFract(fract& x, fract& y)
{
	if(x.num==y.num && x.den==y.den)
		return true;
	else
		return false;
	
}/* isEqualFract */

// z = x + y ; z may be an improper, but always reduced fraction

bool add(fract& z, fract& x, fract& y)
{
	long	xnum, xden, ynum, yden;
	long	temp1, temp2;
	long	factor;

	xnum = x.num;
	xden = x.den;
	ynum = y.num;
	yden = y.den;
	
	factor = reduce(xden, yden);
	
	if(!isGoodMul(xnum, yden))
		return false;
		
	if(!isGoodMul(xden, ynum))
		return false;
		
	temp1 = xnum*yden;
	temp2 = xden*ynum;
	
	if(!isGoodAdd(temp1, temp2))
		return false;
		
	z.num = temp1 + temp2;
	reduce(z.num, factor);
	reduce(z.num, xden);
	reduce(z.num, yden);
	
	if(!isGoodMul(xden, yden))
		return false;
		
	temp1 = xden*yden;
	
	if(!isGoodMul(factor, temp1))
		return false;
		
	z.den = factor*temp1;
		
	return true;
	
}/* add */


// z = x - y
bool sub(fract& z, fract& x, fract& y)
{
	long	xnum, xden, ynum, yden;
	long	temp1, temp2;
	long	factor;

	xnum = x.num;
	xden = x.den;
	ynum = y.num;
	yden = y.den;
	
	factor = reduce(xden, yden);
	
	if(!isGoodMul(xnum, yden))
		return false;
		
	if(!isGoodMul(xden, ynum))
		return false;
		
	temp1 = xnum*yden;
	temp2 = xden*ynum;
	
	if(!isGoodSub(temp1, temp2))
		return false;
		
	z.num = temp1 - temp2;
	reduce(z.num, factor);
	reduce(z.num, xden);
	reduce(z.num, yden);
	
	if(!isGoodMul(xden, yden))
		return false;
		
	temp1 = xden*yden;
	
	if(!isGoodMul(factor, temp1))
		return false;
		
	z.den = factor*temp1;
		
	return true;
	
}/* sub */


// z = x * y
bool mul(fract& z, fract& x, fract& y)
{
	long	xnum, xden, ynum, yden;
	
	xnum = x.num;
	xden = x.den;
	ynum = y.num;
	yden = y.den;
	
	reduce(xnum, yden);
	reduce(xden, ynum);
	
	if(!isGoodMul(xnum, ynum))
		return false;
	
	if(!isGoodMul(xden, yden))
		return false;
	
	z.num = xnum*ynum;
	z.den = xden*yden;
	return true;
	
}/* mul */


// z = x / y
bool div(fract& z, fract& x, fract& y)
{
	long	xnum, xden, ynum, yden;
	
	xnum = x.num;
	xden = x.den;
	ynum = y.num;
	yden = y.den;

	reduce(xnum, ynum);
	reduce(xden, yden);
	
	if(!isGoodMul(xnum, yden))
		return false;
	
	if(!isGoodMul(xden, ynum))
		return false;
	
	z.num = xnum*yden;
	z.den = xden*ynum;
	if(y.num<0)
	{
		z.num = -z.num;
		z.den = -z.den;
	}
	return true;
	
}/* div */


// z = x*x
bool sqr(fract& z, fract& x)
{
	if(!isGoodMul(x.num, x.num))
		return false;
	
	if(!isGoodMul(x.den, x.den))
		return false;
	
	z.num = x.num*x.num;
	z.den = x.den*x.den;
	return true;
	
}/* sqr */


// z = x^y
bool myPow(fract& z, fract& x, long y)
{
	long	temp;
	bool	isNegative;
	
	if(!isGoodPow(x.num, y))
		return false;
	
	if(!isGoodPow(x.den, y))
		return false;
	
	if(y>=0)
	{
		z.num = pow(x.num, y);
		z.den = pow(x.den, y);
	}
	
	if(y<0)
	{
		y = -y;
		z.num = pow(x.num, y);
		z.den = pow(x.den, y);
		
		isNegative = false;
		if(z.num<0)
		{
			isNegative = true;
			z.num = -z.num;
		}
		
		temp = z.num;
		z.num = z.den;
		z.den = temp;
		if(isNegative)
			z.num = -z.num;
	}
	
	return true;
	
}/* myPow */


double convToDouble(fract& x)
{
	double		temp;
	if(x.den!=0)
	{
		temp = x.num;
		return temp/x.den;
	}
	else
		return NAN;
	
}/* convToDouble */