/* MKS.cp */

#include "typedef.h"
#include "fractions.h"
#include "MKS.h"
#include <math.h>

bool addMKS(MKSdata& z, MKSdata& x, MKSdata& y)
{
	long		i;
	
	for(i=0;i<numUnits;i++)
		if(!isEqualFract(x.unit[i], y.unit[i]))
			return false;
	

	z.value = x.value + y.value;
	
	for(i=0;i<numUnits;i++)
	{
		z.unit[i].num = x.unit[i].num;
		z.unit[i].den = x.unit[i].den;
	}
	
	return true;
	
}/* addMKS */


bool subMKS(MKSdata& z, MKSdata& x, MKSdata& y)
{
	long		i;
	
	for(i=0;i<numUnits;i++)
		if(!isEqualFract(x.unit[i], y.unit[i]))
			return false;
	

	z.value = x.value - y.value;
	
	for(i=0;i<numUnits;i++)
	{
		z.unit[i].num = x.unit[i].num;
		z.unit[i].den = x.unit[i].den;
	}
	
	return true;
	
}/* subMKS */


bool mulMKS(MKSdata& z, MKSdata& x, MKSdata& y)
{
	long		i;
	
	z.value = x.value*y.value;
	
	for(i=0;i<numUnits;i++)
		add(z.unit[i], x.unit[i], y.unit[i]);
	
	return true;
	
}/* mulMKS */


bool divMKS(MKSdata& z, MKSdata& x, MKSdata& y)
{
	long		i;
	
	if(y.value==0)
		return false;
		
	z.value = x.value/y.value;
	
	for(i=0;i<numUnits;i++)
		sub(z.unit[i], x.unit[i], y.unit[i]);
	
	return true;
	
}/* divMKS */


bool myPowMKS(MKSdata& z, MKSdata& x, long y)
{
	fract		yFract;
	long		i;
	
	if(x.value==0 && y<=0)
		return false;
	
	if(y==0)
	{
		z.value = 1;
		
		for(i=0;i<numUnits;i++)
		{
			z.unit[i].num = 0;
			z.unit[i].den = 1;
		}
		
		return true;
	}
	
	z.value = pow(x.value, y);
	
	yFract.num = y;
	yFract.den = 1;
	
	for(i=0;i<numUnits;i++)
		mul(z.unit[i], x.unit[i], yFract);
	
	return true;

}/* myPowMKS */


bool myPowMKS2(MKSdata& z, MKSdata& x, fract& y)
{
	long		i;
	
	if(x.value==0 && y.num<=0)
		return false;
	
	if(y.num==0)
	{
		z.value = 1;
		
		for(i=0;i<numUnits;i++)
		{
			z.unit[i].num = 0;
			z.unit[i].den = 1;
		}
		
		return true;
	}
	
	z.value = pow(x.value, (double)y.num/y.den);
	
	for(i=0;i<numUnits;i++)
		mul(z.unit[i], x.unit[i], y);
	
	return true;

}/* myPowMKS2 */


bool sqrMKS(MKSdata& z, MKSdata& x)
{
	fract		yFract;
	long		i;
	
	z.value = x.value*x.value;
	
	yFract.num = 2;
	yFract.den = 1;
	
	for(i=0;i<numUnits;i++)
		mul(z.unit[i], x.unit[i], yFract);
	
	return true;
	
}/* sqrMKS */


bool sqrtMKS(MKSdata& z, MKSdata& x)
{
	fract		yFract;
	long		i;
	
	if(x.value<0)
		return false;
	
	z.value = sqrt(x.value);
	
	yFract.num = 1;
	yFract.den = 2;
	
	for(i=0;i<numUnits;i++)
		mul(z.unit[i], x.unit[i], yFract);
	
	return true;
	
}/* sqrtMKS */

